﻿using System;
using System.Linq;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Threading;
using SPAxnCOMwrapSC;

namespace GetPeakValuesCSWPF
{
    public partial class MainWindow : Window
    {
        AnalyzerSC analyzer = new AnalyzerSC();
        DispatcherTimer timer = new DispatcherTimer();
        public MainWindow()
        {
            InitializeComponent();

            peakNumber.DataContext = this;
            peakNumber.ItemsSource = Enumerable.Range(1, 10).ToList();
            peakNumber.SelectedIndex = 0;

            timer.Interval = TimeSpan.FromMilliseconds(500);
            timer.Tick += Timer_Tick;
        }

        private void AnazlyzerButton_Click(object sender, RoutedEventArgs e)
        {
            analyzer?.Init();
            // Set a realtime mode
            analyzer?.SetMode(0);
            analyzer?.SetSamplingRate(48000);
            analyzer?.SetNumChannels(2);
            analyzer?.SetSamplingPrecision(16);
        }

        private void RunButton_Click(object sender, RoutedEventArgs e)
        {
            analyzer?.Run();
            timer.Start();
        }

        private void StopButton_Click(object sender, RoutedEventArgs e)
        {
            timer.Stop();
            analyzer?.Stop();
        }

        private void CloseButton_Click(object sender, RoutedEventArgs e)
        {
            Close();
        }

        private void frequencies_TextChanged(object sender, TextChangedEventArgs e)
        {
            if (!float.TryParse((e.Source as TextBox).Text, out _))
                Dispatcher.BeginInvoke(new Action(() => (e.Source as TextBox).Undo()));
            else 
                GetResults();
        }

        private void peakNumber_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            GetResults();
        }

        private void Timer_Tick(object sender, EventArgs e)
        {
            GetResults();
        }

        private void GetResults()
        {
            if (peakNumber != null && startHz != null && stopHz != null)
            {
                int peak_number = peakNumber.SelectedIndex;
                float startFreq, stopFreq;

                var dataValid = float.TryParse(startHz.Text, out startFreq);
                dataValid &= float.TryParse(stopHz.Text, out stopFreq);

                if (dataValid)
                {
                    float pk_freq = 0;
                    analyzer?.GetPeakFrequencyNthSpan(0, peak_number, startFreq, stopFreq, out pk_freq);
                    leftFreq.Text = pk_freq.ToString("0.00");

                    analyzer?.GetPeakFrequencyNthSpan(1, peak_number, startFreq, stopFreq, out pk_freq);
                    rightFreq.Text = pk_freq.ToString("0.00");

                    float pk_level = 0;
                    analyzer?.GetPeakAmplitudeNthSpan(0, peak_number, startFreq, stopFreq, out pk_level);
                    leftLevel.Text = pk_level.ToString("0.00");

                    analyzer?.GetPeakAmplitudeNthSpan(1, peak_number, startFreq, stopFreq, out pk_level);
                    rightLevel.Text = pk_level.ToString("0.00");
                }
            }
        }

        /// <summary>
        /// This is validation routine for the numerical TextBox input
        /// </summary>
        private void NumberValidationTextBox(object sender, TextCompositionEventArgs e)
        {
            e.Handled = !(char.IsDigit(e.Text[0]) || e.Text[0] == '.');
        }
    }
}
