﻿using System;
using System.Linq;
using System.Windows.Forms;
using SPAxnCOMwrapSC;

namespace GetPeakValuesCSWinForms
{
    public partial class Form1 : Form
    {
        readonly AnalyzerSC analyzer = new AnalyzerSC();
           
        readonly Timer timer = new Timer();

        public Form1()
        {
            InitializeComponent();

            peakNumber.DataSource = Enumerable.Range(1, 10).ToList();
            peakNumber.SelectedIndex = 0;

            timer.Interval = 500;
            timer.Tick += Timer_Tick;
        }


        /// <summary>
        /// Sets a wait cursor and implements IDisposable so that the cursor can be
        /// restored at the end of a using statement.
        /// </summary>
        public class WaitCursor : IDisposable
        {
            public WaitCursor()
            {
                IsWaitCursor = true;
            }

            public void Dispose()
            {
                IsWaitCursor = false;
            }

            public bool IsWaitCursor
            {
                get
                {
                    return Application.UseWaitCursor;
                }
                set
                {
                    if (Application.UseWaitCursor != value)
                    {
                        Application.UseWaitCursor = value;
                        Cursor.Current = value ? Cursors.WaitCursor : Cursors.Default;
                    }
                }
            }
        }

        private void AnalizerButton_Click(object sender, EventArgs e)
        {
            var wc = new WaitCursor();

            analyzer?.Init(); 

            wc.Dispose();

            // Set a realtime mode
            //analyzer?.SetMode(0);
            //analyzer?.SetSamplingRate(48000);
            //analyzer?.SetNumChannels(2);
            //analyzer?.SetSamplingPrecision(16);
        }

        private void RunButton_Click(object sender, EventArgs e)
        {
            analyzer?.Run();
            timer.Start();
        }

        private void StopButton_Click(object sender, EventArgs e)
        {
            timer.Stop();
            analyzer?.Stop();
        }

        private void CloseButton_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void Frequencies_TextChanged(object sender, EventArgs e)
        {
            GetResults();
        }

        private void PeakNumber_SelectedIndexChanged(object sender, EventArgs e)
        {
            GetResults();
        }

        private void Timer_Tick(object sender, EventArgs e)
        {
            GetResults();
        }

        private void GetResults()
        {
            if (peakNumber != null && startHz != null && stopHz != null)
            {
                int peak_number = peakNumber.SelectedIndex;

                var dataValid = float.TryParse(startHz.Text, out float startFreq);
                dataValid &= float.TryParse(stopHz.Text, out float stopFreq);

                if (dataValid)
                {
                    float pk_freq = 0;
                    analyzer?.GetPeakFrequencyNthSpan(0, peak_number, startFreq, stopFreq, out pk_freq);
                    leftFreq.Text = pk_freq.ToString("0.00");

                    analyzer?.GetPeakFrequencyNthSpan(1, peak_number, startFreq, stopFreq, out pk_freq);
                    rightFreq.Text = pk_freq.ToString("0.00");

                    float pk_level = 0;
                    analyzer?.GetPeakAmplitudeNthSpan(0, peak_number, startFreq, stopFreq, out pk_level);
                    leftLevel.Text = pk_level.ToString("0.00");

                    analyzer?.GetPeakAmplitudeNthSpan(1, peak_number, startFreq, stopFreq, out pk_level);
                    rightLevel.Text = pk_level.ToString("0.00");
                }
            }
        }

        private void FloatOnlyTextBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            // Allow digits, a single decimal point, and control keys
            if (!char.IsControl(e.KeyChar) && !char.IsDigit(e.KeyChar) && e.KeyChar != '.')
            {
                e.Handled = true;
            }

            // Allow only one decimal point
            if (e.KeyChar == '.' && (sender as TextBox).Text.IndexOf('.') > -1)
            {
                e.Handled = true;
            }

            // Allow '-' only as the first character
            if (e.KeyChar == '-' && (sender as TextBox).Text.Length > 0)
            {
                e.Handled = true;
            }
        }

        private void FloatOnlyTextBox_Validating(object sender, System.ComponentModel.CancelEventArgs e)
        {
            TextBox textBox = sender as TextBox;
            if (!float.TryParse(textBox.Text, out _))
            {
                e.Cancel = true;
                textBox.Undo();
            }
        }
    }
}
