﻿Imports System.Windows.Threading
Imports SPAxnCOMwrapSC

Namespace GetPeakValuesVBWPF

    Partial Public Class MainWindow
        Inherits Window

        Private analyzer As New AnalyzerSC()
        Private timer As New DispatcherTimer()

        Public Sub New()
            InitializeComponent()

            peakNumber.DataContext = Me
            peakNumber.ItemsSource = Enumerable.Range(1, 10).ToList()
            peakNumber.SelectedIndex = 0

            timer.Interval = TimeSpan.FromMilliseconds(500)
            AddHandler timer.Tick, AddressOf Timer_Tick
        End Sub

        Private Sub AnazlyzerButton_Click(ByVal sender As Object, ByVal e As RoutedEventArgs)
            analyzer?.Init()
            ' Set a realtime mode
            analyzer?.SetMode(0)
            analyzer?.SetSamplingRate(48000)
            analyzer?.SetNumChannels(2)
            analyzer?.SetSamplingPrecision(16)
        End Sub

        Private Sub RunButton_Click(ByVal sender As Object, ByVal e As RoutedEventArgs)
            analyzer?.Run()
            timer.Start()
        End Sub

        Private Sub StopButton_Click(ByVal sender As Object, ByVal e As RoutedEventArgs)
            timer.Stop()
            analyzer?.Stop()
        End Sub

        Private Sub CloseButton_Click(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Close()
        End Sub

        Private Sub Frequencies_TextChanged(ByVal sender As Object, ByVal e As TextChangedEventArgs)
            If Not Single.TryParse(TryCast(e.Source, TextBox)?.Text, 0.0F) Then
                Dispatcher.BeginInvoke(New Action(Sub() TryCast(e.Source, TextBox)?.Undo()))
            Else
                GetResults()
            End If
        End Sub

        Private Sub PeakNumber_SelectionChanged(sender As Object, e As SelectionChangedEventArgs) Handles peakNumber.SelectionChanged
            GetResults()
        End Sub

        Private Sub Timer_Tick(ByVal sender As Object, ByVal e As EventArgs)
            GetResults()
        End Sub

        Private Sub GetResults()
            If peakNumber IsNot Nothing AndAlso startHz IsNot Nothing AndAlso stopHz IsNot Nothing Then
                Dim peak_number As Integer = peakNumber.SelectedIndex
                Dim startFreq, stopFreq As Single

                Dim dataValid = Single.TryParse(startHz.Text, startFreq)
                dataValid = dataValid And Single.TryParse(stopHz.Text, stopFreq)

                If dataValid Then
                    Dim pk_freq As Single = 0
                    analyzer?.GetPeakFrequencyNthSpan(0, peak_number, startFreq, stopFreq, pk_freq)
                    leftFreq.Text = pk_freq.ToString("0.00")

                    analyzer?.GetPeakFrequencyNthSpan(1, peak_number, startFreq, stopFreq, pk_freq)
                    rightFreq.Text = pk_freq.ToString("0.00")

                    Dim pk_level As Single = 0
                    analyzer?.GetPeakAmplitudeNthSpan(0, peak_number, startFreq, stopFreq, pk_level)
                    leftLevel.Text = pk_level.ToString("0.00")

                    analyzer?.GetPeakAmplitudeNthSpan(1, peak_number, startFreq, stopFreq, pk_level)
                    rightLevel.Text = pk_level.ToString("0.00")
                End If
            End If
        End Sub

        ''' <summary>
        ''' This is validation routine for the numerical TextBox input
        ''' </summary>
        Private Sub NumberValidationTextBox(ByVal sender As Object, ByVal e As TextCompositionEventArgs)
            e.Handled = Not (Char.IsDigit(e.Text(0)) OrElse e.Text(0) = ".")
        End Sub

    End Class
End Namespace
