﻿Imports SPAxnCOMwrapSC

Public Class Form1
    Private analyzer As New AnalyzerSC()
    Private timer As New Timer()

    Public Sub New()
        InitializeComponent()

        peakNumber.DataSource = Enumerable.Range(1, 10).ToList()
        peakNumber.SelectedIndex = 0

        timer.Interval = 500
        AddHandler timer.Tick, AddressOf Timer_Tick
    End Sub

    Private Sub AnalizerButton_Click(ByVal sender As Object, ByVal e As EventArgs) Handles AnalizerButton.Click
        analyzer?.Init()
        ' Set a realtime mode
        analyzer?.SetMode(0)
        analyzer?.SetSamplingRate(48000)
        analyzer?.SetNumChannels(2)
        analyzer?.SetSamplingPrecision(16)
    End Sub

    Private Sub RunButton_Click(ByVal sender As Object, ByVal e As EventArgs) Handles RunButton.Click
        analyzer?.Run()
        timer.Start()
    End Sub

    Private Sub StopButton_Click(ByVal sender As Object, ByVal e As EventArgs) Handles StopButton.Click
        timer.Stop()
        analyzer?.Stop()
    End Sub

    Private Sub CloseButton_Click(ByVal sender As Object, ByVal e As EventArgs) Handles CloseButton.Click
        Close()
    End Sub

    Private Sub Frequencies_TextChanged(ByVal sender As Object, ByVal e As EventArgs) Handles stopHz.TextChanged, startHz.TextChanged
        GetResults()
    End Sub

    Private Sub PeakNumber_SelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs) Handles peakNumber.SelectedIndexChanged
        GetResults()
    End Sub

    Private Sub Timer_Tick(ByVal sender As Object, ByVal e As EventArgs)
        GetResults()
    End Sub

    Private Sub GetResults()
        If peakNumber IsNot Nothing AndAlso startHz IsNot Nothing AndAlso stopHz IsNot Nothing Then
            Dim peak_number As Integer = peakNumber.SelectedIndex
            Dim startFreq, stopFreq As Single

            Dim dataValid = Single.TryParse(startHz.Text, startFreq)
            dataValid = dataValid And Single.TryParse(stopHz.Text, stopFreq)

            If dataValid Then
                Dim pk_freq As Single = 0
                analyzer?.GetPeakFrequencyNthSpan(0, peak_number, startFreq, stopFreq, pk_freq)
                leftFreq.Text = pk_freq.ToString("0.00")

                analyzer?.GetPeakFrequencyNthSpan(1, peak_number, startFreq, stopFreq, pk_freq)
                rightFreq.Text = pk_freq.ToString("0.00")

                Dim pk_level As Single = 0
                analyzer?.GetPeakAmplitudeNthSpan(0, peak_number, startFreq, stopFreq, pk_level)
                leftLevel.Text = pk_level.ToString("0.00")

                analyzer?.GetPeakAmplitudeNthSpan(1, peak_number, startFreq, stopFreq, pk_level)
                rightLevel.Text = pk_level.ToString("0.00")
            End If
        End If
    End Sub

    Private Sub FloatOnlyTextBox_KeyPress(ByVal sender As Object, ByVal e As KeyPressEventArgs)
        ' Allow digits, a single decimal point, and control keys
        If Not Char.IsControl(e.KeyChar) AndAlso Not Char.IsDigit(e.KeyChar) AndAlso e.KeyChar <> "."c Then
            e.Handled = True
        End If

        ' Allow only one decimal point
        If e.KeyChar = "."c AndAlso (TryCast(sender, TextBox)).Text.IndexOf("."c) > -1 Then
            e.Handled = True
        End If

        ' Allow '-' only as the first character
        If e.KeyChar = "-"c AndAlso (TryCast(sender, TextBox)).Text.Length > 0 Then
            e.Handled = True
        End If
    End Sub

    Private Sub FloatOnlyTextBox_Validating(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs)
        Dim textBox As TextBox = TryCast(sender, TextBox)
        If Not Single.TryParse(textBox.Text, 0.0F) Then
            e.Cancel = True
            textBox.Undo()
        End If
    End Sub
End Class
